------------------------------------------------------------------------------
-- Introduction, build wp wells
------------------------------------------------------------------------------
function start1stChapter()

	--Share fog of war for the caravans
	Logic.SetShareExplorationWithPlayerFlag(1,7,1)

	-- army checkrange
	ArmyCheckRange = 7000

	CreateChestOpener("Ari")
	CreateChestOpener("Salim")
	CreateChestOpener("Dario")
	CreateChestOpener("Pilgrim")
	CreateChestOpener("Yuki")
	StartChestQuest()
	CreateRandomGoldChests()	
	
    -- set up and activate player 2

    CreatePlayer2()
    SetPlayerName(3, String.MainKey.."_Player3Name")
    --SetPlayerName(3, "Haendler")
    SetPlayerName(4, String.MainKey.."_Player4Name")
    --SetPlayerName(4, "Haendler")
    SetPlayerName(5, String.MainKey.."_Player5Name")
    --SetPlayerName(5, "Romeo")
	
    -- create the defense armies of steppe robbers

    CreateArmyOne()
    CreateArmyTwo()
    CreateArmyThree()
	CreateArmyPatrol()
	NVCamps()
	CreateQuestSoeldners()

	-- Quest
	CreateQuestCaravanWP()

	-- briefing
    StartCutscene(Cutscenes[INTROCUTSCENE],CreateBriefingPrelude)

	-- lost on hq lost
	AddDefeatEntity("Headquarter")
	
	start1stSubChapter()
	
end
function end1stChapter()
	
	ResolveBriefing(PreludeBriefingQuestTradeRoute) 

	start2ndChapter()

end
------------------------------------------------------------------------------
-- talk to tradelord 3
------------------------------------------------------------------------------
function start2ndChapter()
	
	CreateBriefingTraderLord3()

	CreateNPCTradeLord3()

end
function end2ndChapter()
	ResolveBriefing(Merchant1Page)
	ResolveBriefing(Merchant2Page)
	Logic.SetShareExplorationWithPlayerFlag(1,3,1)

	Logic.GroupAttackMove(scoutID, GetPosition("scoutgo2").X, GetPosition("scoutgo2").Y, 270)
	
	DisableNpcMarker(scoutID)
	DisableNpcMarker("P5_TradeLord3_NPC")

	ResolveBriefing(TraderLord3BriefingShowTradeLord)

	start3rdChapter()
				
end

------------------------------------------------------------------------------
-- escort first caravans 
------------------------------------------------------------------------------
function start3rdChapter()

	CreateQuestCaravans1()
end
function end3rdChapter()

	-- give reward
	ResolveBriefing(ThresholdBriefing1QuestCaravan1)
	ResolveBriefing(ThresholdBriefing1ShowTarget)
	start4thChapter()

end
------------------------------------------------------------------------------
-- escort second caravans 
------------------------------------------------------------------------------
function start4thChapter()
	CreateBriefingCaravan2()
end
function end4thChapter()

	ResolveBriefing(BriefingCaravan2ShowStart)
	ResolveBriefing(BriefingCaravan2ShowTarget)
	
	
	CreateBriefingCaravan3()
	--StartCutscene(Cutscenes[MISSIONCOMPLETECUTSCENE],Victory)

end

function start5thChapter()
Logic.AddQuest(
					1,
					5,
					MAINQUEST_OPEN,
					"Karawanen aus Capulet",
					"Sorgt dafür, dass mindestens neun Karawanen-Wagen aus Capulet unbeschadet den Handelsposten von Alzark erreichen. @cr  @cr Hinweis: @cr Heuert Söldner an, wenn Ihr Unterstützung braucht.",
					1
				)
	StartLastCaravan()
end

function end5thChapter()
	Logic.SetQuestType(1, 5, MAINQUEST_CLOSED, 0)
	StartCutscene(Cutscenes[MISSIONCOMPLETECUTSCENE],Victory)
end
------------------------------------------------------------------------------
-- towers
------------------------------------------------------------------------------
function start1stSubChapter()

	CreateQuestDestroyTowers()

end
function end1stSubChapter()
	
	start2ndSubChapter()
	
end
------------------------------------------------------------------------------
-- Motte
------------------------------------------------------------------------------
function start2ndSubChapter()

	CreateNPCMotte()

	CreateNPCRifle()

end

GameCallback_NPCInteraction = function(_heroId,_npcId)

	if IsBriefingActive() then
		return
	end
	
	if Logic.IsHero(_heroId) then
		
		if _npcId == GetEntityId("feier") then
			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
				createBriefingFeier()
			end
			
		end
		
		if _npcId == GetEntityId("NPCRifle") then
			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
				CreateBriefingNPCRifle()
			end
		end
	
		if _npcId == GetEntityId("NPCMotte") then
			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
				CreateBriefingNPCMotte()
			end
		end
	
		if  _npcId == GetEntityId("P5_TradeLord3_NPC") then
		
			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
				CreateThresholdBriefing1()
			end
		end
		
		if _npcId == GetEntityId("prisonedTrader1") then
		
			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
				suedlicherTraderBriefing()
			end
		end
		
		if  _npcId == GetEntityId("prisonedTrader2") then
		
			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
				noerdlicherTraderBriefing()
			end
		end
		
		
		local id = Logic.GetMerchantBuildingId(_npcId)

		if id ~= 0 then
			GUIAction_MerchantCallback(id, _heroId)
		end
	end
end